# API Documentation

## Base URL
```
http://localhost:3000/api
```

## Authentication

All protected endpoints require a JWT token in the Authorization header:
```
Authorization: Bearer <your-jwt-token>
```

---

## Endpoints

### Authentication

#### Register User
```http
POST /auth/register
```

**Body:**
```json
{
  "email": "user@example.com",
  "password": "password123",
  "name": "John Doe"
}
```

**Response:**
```json
{
  "message": "User registered successfully",
  "token": "jwt-token-here",
  "user": {
    "id": "user-id",
    "email": "user@example.com",
    "name": "John Doe"
  }
}
```

#### Login
```http
POST /auth/login
```

**Body:**
```json
{
  "email": "user@example.com",
  "password": "password123"
}
```

**Response:**
```json
{
  "token": "jwt-token-here",
  "user": {
    "id": "user-id",
    "email": "user@example.com",
    "name": "John Doe",
    "connectedAccounts": {
      "facebook": { "isConnected": true },
      "instagram": { "isConnected": true },
      "whatsapp": { "isConnected": false }
    }
  }
}
```

#### Get Facebook Auth URL
```http
GET /auth/facebook
Headers: Authorization: Bearer <token>
```

**Response:**
```json
{
  "authUrl": "https://facebook.com/v18.0/dialog/oauth?..."
}
```

#### Connect WhatsApp
```http
POST /auth/whatsapp/connect
Headers: Authorization: Bearer <token>
```

**Body:**
```json
{
  "phoneNumberId": "your-phone-number-id",
  "accessToken": "your-whatsapp-token",
  "displayPhoneNumber": "+1234567890"
}
```

#### Get Current User
```http
GET /auth/me
Headers: Authorization: Bearer <token>
```

---

### Messages

#### Get Conversations
```http
GET /messages/conversations?platform=facebook&page=1&limit=20
Headers: Authorization: Bearer <token>
```

**Query Parameters:**
- `platform` (optional): Filter by platform (facebook, instagram, whatsapp)
- `page` (optional): Page number (default: 1)
- `limit` (optional): Items per page (default: 20)

**Response:**
```json
{
  "conversations": [
    {
      "_id": "conversation-id",
      "platform": "facebook",
      "participant": {
        "id": "sender-id",
        "name": "John Customer",
        "profilePic": "https://..."
      },
      "lastMessage": {
        "text": "Hello!",
        "timestamp": "2024-01-10T10:30:00.000Z",
        "isFromUser": false
      },
      "unreadCount": 2,
      "updatedAt": "2024-01-10T10:30:00.000Z"
    }
  ],
  "pagination": {
    "page": 1,
    "limit": 20,
    "total": 45,
    "pages": 3
  }
}
```

#### Get Messages
```http
GET /messages/conversations/:conversationId/messages?page=1&limit=50
Headers: Authorization: Bearer <token>
```

**Response:**
```json
{
  "messages": [
    {
      "_id": "message-id",
      "conversationId": "conversation-id",
      "platform": "facebook",
      "senderId": "sender-id",
      "senderName": "John Customer",
      "text": "Hello, I need help!",
      "isFromBusiness": false,
      "status": "read",
      "timestamp": "2024-01-10T10:30:00.000Z"
    }
  ],
  "pagination": {
    "page": 1,
    "limit": 50,
    "total": 120,
    "pages": 3
  }
}
```

#### Send Message
```http
POST /messages/send
Headers: Authorization: Bearer <token>
```

**Body:**
```json
{
  "conversationId": "conversation-id",
  "text": "Thank you for your message!"
}
```

**Response:**
```json
{
  "message": "Message sent successfully",
  "data": {
    "_id": "message-id",
    "conversationId": "conversation-id",
    "text": "Thank you for your message!",
    "isFromBusiness": true,
    "status": "sent",
    "timestamp": "2024-01-10T10:35:00.000Z"
  }
}
```

#### Get Statistics
```http
GET /messages/stats
Headers: Authorization: Bearer <token>
```

**Response:**
```json
{
  "total": 45,
  "unread": 12,
  "byPlatform": [
    {
      "_id": "facebook",
      "count": 20,
      "unread": 5
    },
    {
      "_id": "instagram",
      "count": 15,
      "unread": 4
    },
    {
      "_id": "whatsapp",
      "count": 10,
      "unread": 3
    }
  ]
}
```

---

### Webhooks

#### Facebook/Instagram Webhook Verification
```http
GET /webhooks/facebook?hub.mode=subscribe&hub.verify_token=<token>&hub.challenge=<challenge>
```

#### Facebook/Instagram Webhook
```http
POST /webhooks/facebook
```

**Body:** (Sent by Facebook)
```json
{
  "object": "page",
  "entry": [
    {
      "id": "page-id",
      "messaging": [
        {
          "sender": { "id": "sender-id" },
          "recipient": { "id": "page-id" },
          "timestamp": 1234567890,
          "message": {
            "mid": "message-id",
            "text": "Hello!"
          }
        }
      ]
    }
  ]
}
```

#### WhatsApp Webhook
```http
POST /webhooks/whatsapp
```

**Body:** (Sent by WhatsApp)
```json
{
  "object": "whatsapp_business_account",
  "entry": [
    {
      "changes": [
        {
          "value": {
            "messages": [
              {
                "from": "1234567890",
                "id": "message-id",
                "timestamp": "1234567890",
                "text": {
                  "body": "Hello!"
                }
              }
            ]
          }
        }
      ]
    }
  ]
}
```

---

## Error Responses

All errors follow this format:
```json
{
  "error": "Error message here"
}
```

**Common Status Codes:**
- `200` - Success
- `201` - Created
- `400` - Bad Request
- `401` - Unauthorized
- `404` - Not Found
- `500` - Internal Server Error
