# Unified Chat System Backend

A unified messaging backend that integrates Facebook Messenger, Instagram DMs, and WhatsApp Business API.

## Features

- 🔐 OAuth integration for Facebook, Instagram, and WhatsApp
- 📨 Receive messages from all three platforms via webhooks
- 💬 Send replies through a unified API
- 📊 Unified inbox with all conversations
- 🔄 Real-time message synchronization

## Prerequisites

- Node.js (v16 or higher)
- MongoDB
- Facebook Developer Account with an app
- WhatsApp Business Account

## Setup

1. **Install dependencies:**
   ```bash
   npm install
   ```

2. **Configure environment variables:**
   - Copy `.env.example` to `.env`
   - Fill in your Facebook App credentials
   - Add your WhatsApp Business API credentials
   - Set a secure JWT secret

3. **Facebook App Configuration:**
   - Go to [Facebook Developers](https://developers.facebook.com)
   - Add Messenger, Instagram, and WhatsApp products to your app
   - Configure webhooks for each platform
   - Set webhook URL: `https://your-domain.com/api/webhooks/facebook`
   - Set verify token (same as in your .env)
   - Subscribe to messages, messaging_postbacks events

4. **Start MongoDB:**
   ```bash
   # If using local MongoDB
   mongod
   ```

5. **Run the server:**
   ```bash
   # Development mode
   npm run dev

   # Production mode
   npm start
   ```

## API Endpoints

### Authentication
- `POST /api/auth/register` - Register a new user
- `POST /api/auth/login` - Login user
- `GET /api/auth/facebook` - Initiate Facebook OAuth
- `GET /api/auth/facebook/callback` - Facebook OAuth callback

### Messages
- `GET /api/messages` - Get all conversations
- `GET /api/messages/:conversationId` - Get messages for a conversation
- `POST /api/messages/send` - Send a message

### Webhooks
- `GET /api/webhooks/facebook` - Webhook verification
- `POST /api/webhooks/facebook` - Receive Facebook/Instagram messages
- `GET /api/webhooks/whatsapp` - WhatsApp webhook verification
- `POST /api/webhooks/whatsapp` - Receive WhatsApp messages

## Facebook App Permissions Required

- `pages_messaging`
- `pages_manage_metadata`
- `instagram_basic`
- `instagram_manage_messages`
- `whatsapp_business_messaging`
- `whatsapp_business_management`

## Project Structure

```
src/
├── config/         # Configuration files
├── controllers/    # Request handlers
├── models/         # Database models
├── routes/         # API routes
├── services/       # Business logic
├── middleware/     # Custom middleware
└── utils/          # Helper functions
```

## Webhook Setup

Your webhook URL must be publicly accessible. For local development:
- Use ngrok: `ngrok http 3000`
- Use the ngrok URL in Facebook webhook configuration

## License

ISC
