# Facebook Developer App Setup Guide

## Step 1: Create Facebook App

1. Go to [Facebook Developers](https://developers.facebook.com)
2. Click "My Apps" → "Create App"
3. Select "Business" as use case
4. Fill in app details:
   - App Name: Your app name
   - App Contact Email: Your email
   - Business Account (optional)

## Step 2: Add Products

### Facebook Messenger
1. In your app dashboard, click "Add Product"
2. Find "Messenger" and click "Set Up"
3. Scroll to "Access Tokens"
4. Add or select a Facebook Page
5. Copy the Page Access Token (save this)

### Instagram
1. Click "Add Product" → "Instagram"
2. Click "Set Up"
3. Make sure your Instagram account is a Business or Creator account
4. Connect your Instagram account to your Facebook Page
5. The same Page Access Token works for Instagram

### WhatsApp
1. Click "Add Product" → "WhatsApp"
2. Click "Set Up"
3. Follow the setup wizard to:
   - Add a phone number
   - Verify your business
   - Get your WhatsApp Business Account ID
   - Get your Phone Number ID
   - Generate a permanent access token

## Step 3: Configure Webhooks

### For Facebook Messenger & Instagram

1. In your app, go to Messenger → Settings
2. In "Webhooks" section, click "Add Callback URL"
3. Enter:
   - Callback URL: `https://your-domain.com/api/webhooks/facebook`
   - Verify Token: Create a random string (save this for .env)
4. Click "Verify and Save"
5. Subscribe to these webhook fields:
   - `messages`
   - `messaging_postbacks`
   - `message_reads`
   - `message_deliveries`

6. Go to Instagram → Settings
7. Repeat webhook setup for Instagram
8. Subscribe to:
   - `messages`
   - `messaging_postbacks`

### For WhatsApp

1. Go to WhatsApp → Configuration
2. In "Webhook" section:
   - Callback URL: `https://your-domain.com/api/webhooks/whatsapp`
   - Verify Token: Same as above or different
3. Subscribe to webhook fields:
   - `messages`
   - `message_status`

## Step 4: App Review & Permissions

### Required Permissions for Messenger:
- `pages_messaging` - Send and receive messages
- `pages_manage_metadata` - Get page information
- `pages_show_list` - List user's pages

### Required Permissions for Instagram:
- `instagram_basic` - Basic Instagram account info
- `instagram_manage_messages` - Send and receive Instagram messages

### Required Permissions for WhatsApp:
- `whatsapp_business_messaging` - Send and receive messages
- `whatsapp_business_management` - Manage WhatsApp Business account

**Note:** These permissions require App Review for production. For development:
- Add test users in App Roles → Roles
- Test users can use the app without review

## Step 5: Get Your Credentials

From your Facebook App Dashboard, note these values:

1. **App ID**: Dashboard → Settings → Basic
2. **App Secret**: Dashboard → Settings → Basic (Click "Show")
3. **Page Access Token**: Messenger → Settings → Access Tokens
4. **WhatsApp Phone Number ID**: WhatsApp → API Setup
5. **WhatsApp Business Account ID**: WhatsApp → API Setup
6. **Verify Token**: The one you created for webhooks

## Step 6: Configure .env File

Copy these values to your `.env` file:

```env
FACEBOOK_APP_ID=your-app-id
FACEBOOK_APP_SECRET=your-app-secret
FACEBOOK_VERIFY_TOKEN=your-verify-token
WEBHOOK_VERIFY_TOKEN=your-webhook-verify-token
WHATSAPP_PHONE_NUMBER_ID=your-phone-number-id
WHATSAPP_BUSINESS_ACCOUNT_ID=your-business-account-id
WHATSAPP_ACCESS_TOKEN=your-whatsapp-permanent-token
```

## Step 7: Test Your Setup

1. Use [ngrok](https://ngrok.com) for local testing:
   ```bash
   ngrok http 3000
   ```

2. Update webhook URLs with ngrok URL

3. Send a test message to your:
   - Facebook Page
   - Instagram Business account
   - WhatsApp Business number

4. Check your server logs for incoming webhooks

## Common Issues

### Webhook Verification Fails
- Check verify token matches
- Ensure webhook URL is publicly accessible
- Check server logs for errors

### Messages Not Received
- Verify webhook subscriptions are active
- Check Facebook App is not in development mode restrictions
- Ensure page/account is connected properly

### Cannot Send Messages
- Verify access tokens are valid and not expired
- Check required permissions are granted
- For WhatsApp: Ensure you're within 24-hour messaging window

## Production Checklist

- [ ] Submit app for review
- [ ] Request required permissions
- [ ] Add Privacy Policy URL
- [ ] Add Terms of Service URL
- [ ] Complete Business Verification
- [ ] Switch from test to production mode
- [ ] Use permanent access tokens
- [ ] Set up proper error logging
- [ ] Implement rate limiting
- [ ] Set up monitoring

## Resources

- [Facebook Messenger Platform Docs](https://developers.facebook.com/docs/messenger-platform)
- [Instagram Messaging API Docs](https://developers.facebook.com/docs/messenger-platform/instagram)
- [WhatsApp Business API Docs](https://developers.facebook.com/docs/whatsapp)
