const dotenv = require('dotenv');

dotenv.config();

module.exports = {
  port: process.env.PORT || 3000,
  nodeEnv: process.env.NODE_ENV || 'development',
  mongoUri: process.env.MONGODB_URI || 'mongodb://localhost:27017/unified-chat-system',
  jwtSecret: process.env.JWT_SECRET || 'your-secret-key',
  
  facebook: {
    appId: process.env.FACEBOOK_APP_ID,
    appSecret: process.env.FACEBOOK_APP_SECRET,
    verifyToken: process.env.FACEBOOK_VERIFY_TOKEN,
    graphApiVersion: process.env.GRAPH_API_VERSION || 'v18.0',
  },
  
  whatsapp: {
    phoneNumberId: process.env.WHATSAPP_PHONE_NUMBER_ID,
    businessAccountId: process.env.WHATSAPP_BUSINESS_ACCOUNT_ID,
    accessToken: process.env.WHATSAPP_ACCESS_TOKEN,
  },
  
  webhook: {
    verifyToken: process.env.WEBHOOK_VERIFY_TOKEN,
  },
  
  frontend: {
    url: process.env.FRONTEND_URL || 'http://localhost:5173',
  },
};
