const mongoose = require('mongoose');

const conversationSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
  },
  platform: {
    type: String,
    enum: ['facebook', 'instagram', 'whatsapp'],
    required: true,
  },
  platformConversationId: {
    type: String,
    required: true,
  },
  participant: {
    id: String,
    name: String,
    profilePic: String,
  },
  lastMessage: {
    text: String,
    timestamp: Date,
    isFromUser: Boolean,
  },
  unreadCount: {
    type: Number,
    default: 0,
  },
  createdAt: {
    type: Date,
    default: Date.now,
  },
  updatedAt: {
    type: Date,
    default: Date.now,
  },
});

// Compound index for faster queries
conversationSchema.index({ userId: 1, platform: 1, platformConversationId: 1 });

module.exports = mongoose.model('Conversation', conversationSchema);
