const mongoose = require('mongoose');

const messageSchema = new mongoose.Schema({
  conversationId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Conversation',
    required: true,
  },
  platform: {
    type: String,
    enum: ['facebook', 'instagram', 'whatsapp'],
    required: true,
  },
  platformMessageId: {
    type: String,
    required: true,
  },
  senderId: {
    type: String,
    required: true,
  },
  senderName: String,
  text: String,
  attachments: [{
    type: {
      type: String,
      enum: ['image', 'video', 'audio', 'file'],
    },
    url: String,
    mimeType: String,
  }],
  isFromBusiness: {
    type: Boolean,
    default: false,
  },
  status: {
    type: String,
    enum: ['sent', 'delivered', 'read', 'failed'],
    default: 'sent',
  },
  timestamp: {
    type: Date,
    default: Date.now,
  },
});

// Index for faster queries
messageSchema.index({ conversationId: 1, timestamp: -1 });

module.exports = mongoose.model('Message', messageSchema);
