const express = require('express');
const router = express.Router();
const authController = require('../controllers/authController');
const authMiddleware = require('../middleware/auth');

// Public routes
router.post('/register', authController.register);
router.post('/login', authController.login);

// Protected routes
router.get('/facebook', authMiddleware, authController.getFacebookAuthUrl);
router.get('/facebook/callback', authController.facebookCallback);
router.post('/whatsapp/connect', authMiddleware, authController.connectWhatsApp);
router.get('/me', authMiddleware, authController.getCurrentUser);

module.exports = router;
