const express = require('express');
const router = express.Router();
const messageController = require('../controllers/messageController');
const authMiddleware = require('../middleware/auth');

// All routes require authentication
router.use(authMiddleware);

// Message routes
router.get('/conversations', messageController.getConversations);
router.get('/conversations/:conversationId/messages', messageController.getMessages);
router.post('/send', messageController.sendMessage);
router.get('/stats', messageController.getStats);

module.exports = router;
