const express = require('express');
const router = express.Router();
const webhookController = require('../controllers/webhookController');

// Facebook/Instagram webhooks
router.get('/facebook', webhookController.verifyFacebookWebhook);
router.post('/facebook', webhookController.handleFacebookWebhook);

// WhatsApp webhooks
router.get('/whatsapp', webhookController.verifyWhatsAppWebhook);
router.post('/whatsapp', webhookController.handleWhatsAppWebhook);

module.exports = router;
