const axios = require('axios');
const config = require('../config/config');

class InstagramService {
  constructor() {
    this.baseUrl = `https://graph.facebook.com/${config.facebook.graphApiVersion}`;
  }

  /**
   * Send a message via Instagram Direct
   */
  async sendMessage(pageAccessToken, recipientId, messageText) {
    try {
      const response = await axios.post(
        `${this.baseUrl}/me/messages`,
        {
          recipient: { id: recipientId },
          message: { text: messageText },
        },
        {
          params: { access_token: pageAccessToken },
        }
      );
      return response.data;
    } catch (error) {
      console.error('Instagram send message error:', error.response?.data || error.message);
      throw error;
    }
  }

  /**
   * Get Instagram business account
   */
  async getInstagramAccount(pageAccessToken, pageId) {
    try {
      const response = await axios.get(`${this.baseUrl}/${pageId}`, {
        params: {
          fields: 'instagram_business_account',
          access_token: pageAccessToken,
        },
      });
      return response.data.instagram_business_account;
    } catch (error) {
      console.error('Instagram get account error:', error.response?.data || error.message);
      throw error;
    }
  }

  /**
   * Get Instagram profile information
   */
  async getProfile(pageAccessToken, igAccountId) {
    try {
      const response = await axios.get(`${this.baseUrl}/${igAccountId}`, {
        params: {
          fields: 'username,profile_picture_url,name',
          access_token: pageAccessToken,
        },
      });
      return response.data;
    } catch (error) {
      console.error('Instagram get profile error:', error.response?.data || error.message);
      return null;
    }
  }

  /**
   * Get conversation details
   */
  async getConversation(pageAccessToken, conversationId) {
    try {
      const response = await axios.get(`${this.baseUrl}/${conversationId}`, {
        params: {
          fields: 'participants,messages{message,from,created_time}',
          access_token: pageAccessToken,
        },
      });
      return response.data;
    } catch (error) {
      console.error('Instagram get conversation error:', error.response?.data || error.message);
      return null;
    }
  }
}

module.exports = new InstagramService();
