/**
 * Format error response
 */
const formatError = (error) => {
  if (error.response) {
    // API error response
    return {
      message: error.response.data.error?.message || error.message,
      code: error.response.data.error?.code,
      status: error.response.status,
    };
  }
  
  return {
    message: error.message,
    code: error.code,
  };
};

/**
 * Format success response
 */
const formatSuccess = (data, message = 'Success') => {
  return {
    success: true,
    message,
    data,
  };
};

/**
 * Pagination helper
 */
const getPagination = (page, limit, total) => {
  const currentPage = parseInt(page) || 1;
  const itemsPerPage = parseInt(limit) || 20;
  const totalPages = Math.ceil(total / itemsPerPage);

  return {
    page: currentPage,
    limit: itemsPerPage,
    total,
    totalPages,
    hasNext: currentPage < totalPages,
    hasPrev: currentPage > 1,
  };
};

module.exports = {
  formatError,
  formatSuccess,
  getPagination,
};
